/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.micro.shunt.autoconfig;

import com.xunyi.micro.propagation.Propagation;
import com.xunyi.micro.shunt.Shunt;
import com.xunyi.micro.shunt.autoconfig.ShuntProperties;
import com.xunyi.micro.shunt.propagation.CurrentShuntContext;
import com.xunyi.micro.shunt.propagation.ShuntPropagation;
import com.xunyi.micro.shunt.propagation.ThreadLocalCurrentShuntContext;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"micro.shunt.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={ShuntProperties.class})
public class ShuntAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public CurrentShuntContext currentShuntContext() {
        return ThreadLocalCurrentShuntContext.create();
    }

    @Bean
    @ConditionalOnMissingBean
    public Shunt shunt(CurrentShuntContext currentShuntContext) {
        Shunt.ShuntBuilder builder = Shunt.builder().currentShuntContext(currentShuntContext).propagation(new ShuntPropagation<String>(Propagation.KeyFactory.STRING));
        return builder.build();
    }
}

