/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.micro.security.configuration;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xunyi.micro.security.PryService;
import com.xunyi.micro.security.configuration.PryPolicyDataSource;
import com.xunyi.micro.security.configuration.PryProperties;
import com.xunyi.micro.security.policy.PryMapper;
import com.xunyi.micro.security.policy.PryPolicy;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.SimpleTypeConverter;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.cloud.context.scope.refresh.RefreshScopeRefreshedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.support.ApplicationObjectSupport;
import org.springframework.lang.NonNull;
import org.springframework.util.ReflectionUtils;

public class PryPolicyConfigService
extends ApplicationObjectSupport
implements InitializingBean,
ApplicationListener<RefreshScopeRefreshedEvent> {
    private TypeConverter typeConverter = new SimpleTypeConverter();
    @Autowired
    private PryService pryService;
    private PryPolicyDataSource source;
    private PryPolicyConfigRunnable runnable = new PryPolicyConfigRunnable();

    public PryPolicyConfigService(PryPolicyDataSource source) {
        this.source = source;
    }

    public void afterPropertiesSet() throws Exception {
        this.start();
    }

    public void start() {
        this.runnable.run();
    }

    public void onApplicationEvent(@NonNull RefreshScopeRefreshedEvent refreshScopeRefreshedEvent) {
        this.runnable.run();
    }

    public class PryPolicyConfigRunnable
    implements Runnable {
        @Override
        public void run() {
            try {
                PryProperties properties = PryPolicyConfigService.this.source.readProperties();
                ArrayList mappers = Lists.newArrayList();
                HashMap policyMap = Maps.newHashMap();
                for (PryProperties.PryMapper mapperProperty : properties.getMapper()) {
                    PryMapper mapper = new PryMapper();
                    BeanUtils.copyProperties((Object)mapperProperty, (Object)mapper);
                    mappers.add(mapper);
                }
                for (PryProperties.PryPolicy policyProperty : properties.getPolicy()) {
                    String className = policyProperty.getClazz();
                    PryPolicy policy = this.loadPolicy(className, policyProperty.getInitParams());
                    policyMap.put(policyProperty.getName(), policy);
                }
                PryPolicyConfigService.this.pryService.configuration(mappers, policyMap);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private PryPolicy loadPolicy(String className, Map<String, String> initParams) throws Exception {
            Class<?> clazz = Class.forName(className);
            AutowireCapableBeanFactory beanFactory = PryPolicyConfigService.this.getApplicationContext().getAutowireCapableBeanFactory();
            PryPolicy target = (PryPolicy)beanFactory.createBean(clazz);
            for (Field field : clazz.getDeclaredFields()) {
                String fieldName = field.getName();
                if (!initParams.containsKey(fieldName)) continue;
                Class<?> fieldType = field.getType();
                String valueString = initParams.get(fieldName);
                Object value = PryPolicyConfigService.this.typeConverter.convertIfNecessary((Object)valueString, fieldType);
                ReflectionUtils.makeAccessible((Field)field);
                ReflectionUtils.setField((Field)field, (Object)target, (Object)value);
            }
            return target;
        }
    }
}

