/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.micro.id;

import com.xunyi.micro.id.IDGenerator;
import java.util.Base64;

public class SnowflakeGenerator
implements IDGenerator {
    private static final long ORIGIN_TIME = 1480166465631L;
    private static final long TIMESTAMP_BIT = 41L;
    private static final long DATA_CENTER_BIT = 5L;
    private static final long WORKER_BIT = 5L;
    private static final long SEQUENCE_BIT = 10L;
    private static final long TIMESTAMP_MASK = 0x1FFFFFFFFFFL;
    private static final long DATA_CENTER_MASK = 31L;
    private static final long WORKER_MASK = 31L;
    private static final long SEQUENCE_MASK = 1023L;
    private static final long TIMESTAMP_SHIFT = 20L;
    private static final long DATA_CENTER_SHIFT = 15L;
    private static final long WORKER_SHIFT = 10L;
    private long lastTime = -1L;
    private long dataCenterId;
    private long workerId;
    private long sequence = 0L;
    private Base64.Encoder encoder = Base64.getUrlEncoder();
    private static final char[] toBase62 = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

    protected long nextTime() {
        long timestamp = this.time();
        while (timestamp <= this.lastTime) {
            timestamp = this.time();
        }
        return timestamp;
    }

    protected long time() {
        return System.currentTimeMillis();
    }

    @Override
    public String name() {
        return "Snowflake";
    }

    public SnowflakeGenerator(long dataCenterId, long workerId) {
        if (dataCenterId > 31L || dataCenterId < 0L) {
            throw new IllegalArgumentException("dataCenterId can't be geater then DATA_CENTER_MASK");
        }
        if (workerId > 31L || workerId < 0L) {
            throw new IllegalArgumentException("workerId can't be geater then WORKER_MASK");
        }
        this.dataCenterId = dataCenterId;
        this.workerId = workerId;
    }

    @Override
    public synchronized String nextId() {
        long now = this.time();
        if (now < this.lastTime) {
            throw new RuntimeException("Clock moved backwards.  Refusing to generate id");
        }
        if (now == this.lastTime) {
            this.sequence = this.sequence + 1L & 0x3FFL;
            if (this.sequence == 0L) {
                now = this.nextTime();
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTime = now;
        long time = now - 1480166465631L;
        long id = time << 20 | this.dataCenterId << 15 | this.workerId << 10 | this.sequence;
        char[] chars = new char[12];
        int i = 12;
        long value = id;
        while (i-- > 0) {
            chars[i] = toBase62[(int)(value % 62L)];
            value /= 62L;
        }
        return new String(chars);
    }
}

