/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.micro.grpc.discovery;

import com.google.common.collect.Lists;
import com.xunyi.micro.grpc.GRPCChannelFactory;
import com.xunyi.micro.grpc.GRPCChannelProperties;
import com.xunyi.micro.grpc.GRPCChannelsProperties;
import com.xunyi.micro.grpc.discovery.DiscoveryNameResolverProvider;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import io.grpc.ManagedChannel;
import io.grpc.NameResolver;
import io.grpc.netty.NettyChannelBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.springframework.cloud.client.discovery.DiscoveryClient;

public class DiscoveryChannelFactory
implements GRPCChannelFactory {
    private final GRPCChannelsProperties properties;
    private final DiscoveryClient client;
    private final List<ClientInterceptor> globalInterceptor;

    public DiscoveryChannelFactory(GRPCChannelsProperties properties, DiscoveryClient client, List<ClientInterceptor> globalInterceptor) {
        this.properties = properties;
        this.client = client;
        this.globalInterceptor = Lists.newArrayList(globalInterceptor);
    }

    @Override
    public Channel createChannel(String name) {
        return this.createChannel(name, null);
    }

    @Override
    public Channel createChannel(String name, List<ClientInterceptor> interceptors) {
        GRPCChannelProperties channelProperties = this.properties.getChannel(name);
        NettyChannelBuilder builder = ((NettyChannelBuilder)NettyChannelBuilder.forTarget((String)name).nameResolverFactory((NameResolver.Factory)new DiscoveryNameResolverProvider(this.client))).negotiationType(channelProperties.getNegotiationType());
        if (channelProperties.isEnableKeepAlive()) {
            builder.keepAliveWithoutCalls(channelProperties.isKeepAliveWithoutCalls()).keepAliveTime(channelProperties.getKeepAliveTime(), TimeUnit.SECONDS).keepAliveTimeout(channelProperties.getKeepAliveTimeout(), TimeUnit.SECONDS);
        }
        if (channelProperties.getMaxInboundMessageSize() > 0) {
            builder.maxInboundMessageSize(channelProperties.getMaxInboundMessageSize());
        }
        ManagedChannel channel = builder.build();
        ArrayList interceptorList = Lists.newArrayList(this.globalInterceptor);
        if (Objects.nonNull(interceptors)) {
            interceptorList.addAll(interceptors);
        }
        return ClientInterceptors.intercept((Channel)channel, (List)interceptorList);
    }
}

