/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.micro.data.util;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExporter<T>
implements Flushable {
    private static final Logger log = LoggerFactory.getLogger(AbstractExporter.class);
    private int writeCount = 0;
    private static final int BLOCK_SIZE = 100;

    public void write(Iterator<T> iterator) throws IOException {
        try {
            while (iterator.hasNext()) {
                T value = iterator.next();
                this.writeObject(value);
                ++this.writeCount;
                if (this.writeCount % 100 != 0) continue;
                this.flush();
            }
            this.flush();
        }
        finally {
            if (iterator instanceof Closeable) {
                ((Closeable)((Object)iterator)).close();
            }
        }
    }

    public abstract void writeObject(T var1) throws IOException;
}

