/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.micro.data.repository.ibatis;

import com.google.common.base.CaseFormat;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.scripting.LanguageDriver;
import org.apache.ibatis.scripting.xmltags.XMLLanguageDriver;
import org.apache.ibatis.session.Configuration;
import org.springframework.beans.BeanUtils;

public class SimpleInsertLangDriver
extends XMLLanguageDriver
implements LanguageDriver {
    private final Pattern ofInsertPattern = Pattern.compile("\\sof(\\s+parameter|\\s*\\([\\s\\S]*\\))\\s*$");

    public SqlSource createSqlSource(Configuration configuration, String script, Class<?> parameterType) {
        Matcher matcher = this.ofInsertPattern.matcher((CharSequence)script);
        if (matcher.find()) {
            boolean isForeach;
            String group = matcher.group(1).trim();
            boolean isArray = parameterType.isArray();
            boolean isCollection = Collection.class.isAssignableFrom(parameterType);
            boolean isParameterToken = "parameter".equals(group);
            ArrayList fieldNames = Lists.newArrayList();
            if (isParameterToken) {
                if (isCollection) {
                    throw new IllegalArgumentException("parameterType is Collection, not use parameter token");
                }
                PropertyDescriptor[] propertyDescriptors = isArray ? BeanUtils.getPropertyDescriptors(parameterType.getComponentType()) : BeanUtils.getPropertyDescriptors(parameterType);
                for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
                    Method readMethod = propertyDescriptor.getReadMethod();
                    Method writeMethod = propertyDescriptor.getWriteMethod();
                    if (readMethod == null || writeMethod == null) continue;
                    fieldNames.add(propertyDescriptor.getName());
                }
            } else {
                for (Object name : Splitter.on((String)",").split((CharSequence)group.substring(1, group.length() - 1))) {
                    fieldNames.add(((String)name).trim());
                }
            }
            ArrayList sqlFieldsNames = Lists.newArrayList();
            for (String fieldName : fieldNames) {
                String sqlFieldName = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, fieldName);
                sqlFieldsNames.add(sqlFieldName);
            }
            StringBuilder replaceScript = new StringBuilder();
            replaceScript.append("(");
            Joiner.on((String)",").appendTo(replaceScript, sqlFieldsNames.stream().map(item -> "`" + item + "`").iterator());
            replaceScript.append(") VALUES ");
            String prefix = null;
            boolean bl = isForeach = isArray || isCollection;
            if (isForeach) {
                if (isArray) {
                    replaceScript.append("<foreach item=\"item\" collection=\"array\" separator=\",\">");
                } else {
                    replaceScript.append("<foreach item=\"item\" collection=\"list\" separator=\",\">");
                }
                prefix = "item.";
            }
            replaceScript.append("( ");
            Iterator parts = fieldNames.iterator();
            if (parts.hasNext()) {
                replaceScript.append("#{");
                if (prefix != null) {
                    replaceScript.append(prefix);
                }
                replaceScript.append((String)parts.next());
                replaceScript.append("}");
                while (parts.hasNext()) {
                    replaceScript.append(",");
                    replaceScript.append("#{");
                    if (prefix != null) {
                        replaceScript.append(prefix);
                    }
                    replaceScript.append((String)parts.next());
                    replaceScript.append("}");
                }
            }
            replaceScript.append(")");
            if (isForeach) {
                replaceScript.append("</foreach>");
            }
            script = "<script>" + matcher.replaceAll(replaceScript.toString()) + "</script>";
        }
        return super.createSqlSource(configuration, (String)script, parameterType);
    }
}

