/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.micro.access.predicate;

import com.xunyi.micro.access.AccessContext;
import com.xunyi.micro.access.predicate.AbstractPredicateFactory;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.function.Predicate;
import org.springframework.util.Assert;

public class BetweenPredicateFactory
extends AbstractPredicateFactory<Config> {
    private static DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withZone(ZoneId.systemDefault());

    @Override
    public Predicate<AccessContext> apply(Config config) {
        final Instant beginAt = config.beginAt;
        final Instant endAt = config.endAt;
        Assert.isTrue((boolean)beginAt.isBefore(endAt), (String)(FORMATTER.format(beginAt) + " must be before " + FORMATTER.format(endAt)));
        return new Predicate<AccessContext>(){

            @Override
            public boolean test(AccessContext accessContext) {
                Instant now = Instant.now();
                return now.isAfter(beginAt) && now.isBefore(endAt);
            }
        };
    }

    public static class Config {
        private Instant beginAt;
        private Instant endAt;

        public Instant getBeginAt() {
            return this.beginAt;
        }

        public Instant getEndAt() {
            return this.endAt;
        }

        public void setBeginAt(Instant beginAt) {
            this.beginAt = beginAt;
        }

        public void setEndAt(Instant endAt) {
            this.endAt = endAt;
        }
    }
}

