/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.valiation;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.trie4j.patricia.TailPatriciaTrie;

public class TabooUtils {
    private static final Logger log = LoggerFactory.getLogger(TabooUtils.class);
    private static TailPatriciaTrie PAT = new TailPatriciaTrie();

    public static String findWord(CharSequence chars) {
        StringBuilder builder = new StringBuilder();
        int index = PAT.findShortestWord(chars, 0, chars.length(), builder);
        if (index >= 0) {
            log.warn("find chars:{} taboo index:{} taboo word: {}", new Object[]{chars, index, builder});
        }
        return builder.toString();
    }

    static {
        DefaultResourceLoader loader = new DefaultResourceLoader();
        Resource resource = loader.getResource("classpath:taboo/words.txt");
        try (InputStream is = resource.getInputStream();){
            List keywords = IOUtils.readLines((InputStream)is, (Charset)StandardCharsets.UTF_8);
            log.info("load keywords size:{}", (Object)keywords.size());
            for (String keyword : keywords) {
                PAT.insert(keyword);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

