/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.micro.token.support;

import com.xunyi.micro.token.MobileToken;
import com.xunyi.micro.token.support.AbstractTokenJwt;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.SignatureAlgorithm;
import java.security.Key;
import java.time.Instant;
import java.util.Map;

public class MobileTokenJwt
extends AbstractTokenJwt<MobileToken> {
    private static final String PRIV_RESOURCE = "classpath:mobile-token-private.der";
    private static final String PUB_RESOURCE = "classpath:mobile-token-public.der";
    private static final SignatureAlgorithm SIGNATURE_ALGORITHM = SignatureAlgorithm.RS256;

    public static class Builder
    extends AbstractTokenJwt.AbstractTokenJwtBuilder<MobileToken> {
        public Builder() {
            this(AbstractTokenJwt.readPrivateKey(MobileTokenJwt.PRIV_RESOURCE), SIGNATURE_ALGORITHM);
        }

        public Builder(Key key, SignatureAlgorithm algorithm) {
            super(key, algorithm);
        }

        @Override
        protected void write(Map<String, Object> claims, MobileToken token) {
            claims.put("verify-mode", (Object)token.getVerifyMode());
            claims.put("mobile", token.getMobile());
            claims.put("iss", token.getIssuedAt().toEpochMilli());
            claims.put("exp", token.getExpiresAt().toEpochMilli());
        }
    }

    public static class Parser
    extends AbstractTokenJwt.AbstractTokenJwtParser<MobileToken> {
        public Parser() {
            this(AbstractTokenJwt.readPublicKey(MobileTokenJwt.PUB_RESOURCE));
        }

        public Parser(Key key) {
            super(key);
        }

        @Override
        protected MobileToken read(Claims claims) {
            MobileToken token = new MobileToken();
            String verifyModeString = (String)claims.get("verify-mode", String.class);
            token.setVerifyMode(MobileToken.VerifyMode.valueOf(verifyModeString));
            token.setMobile((String)claims.get("mobile", String.class));
            token.setIssuedAt(Instant.ofEpochMilli((Long)claims.get("iss", Long.class)));
            token.setExpiresAt(Instant.ofEpochMilli((Long)claims.get("exp", Long.class)));
            token.verify();
            return token;
        }
    }

    private static final class CLAIM_NAMES {
        private static final String VERIFY_MODE = "verify-mode";
        private static final String MOBILE = "mobile";
        private static final String ISSUED_AT = "iss";
        private static final String EXPIRES_AT = "exp";

        private CLAIM_NAMES() {
        }
    }
}

