/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.micro.shunt.web;

import com.xunyi.micro.shunt.Shunt;
import com.xunyi.micro.shunt.autoconfig.ShuntAutoConfiguration;
import com.xunyi.micro.shunt.web.servlet.ShuntFilter;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"micro.shunt.web.enabled"}, matchIfMissing=true)
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@AutoConfigureAfter(value={ShuntAutoConfiguration.class})
public class ShuntWebServletAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public ShuntFilter shuntFilter(Shunt shunt) {
        return new ShuntFilter(shunt);
    }

    @Bean
    public FilterRegistrationBean shuntServletFilter(ShuntFilter shuntFilter) {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean((Filter)shuntFilter, new ServletRegistrationBean[0]);
        filterRegistrationBean.setDispatcherTypes(DispatcherType.ASYNC, new DispatcherType[]{DispatcherType.ERROR, DispatcherType.FORWARD, DispatcherType.INCLUDE, DispatcherType.REQUEST});
        filterRegistrationBean.setOrder(-2147483643);
        return filterRegistrationBean;
    }
}

