/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.micro.propagation.web.client.feign;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xunyi.micro.propagation.Propagation;
import com.xunyi.micro.propagation.context.Injector;
import com.xunyi.micro.shunt.Shunt;
import com.xunyi.micro.shunt.propagation.ShuntContext;
import feign.Client;
import feign.Request;
import feign.Response;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InjectorFeignClient
implements Client {
    private static final Logger log = LoggerFactory.getLogger(InjectorFeignClient.class);
    static final Propagation.Setter<Map<String, Collection<String>>, String> SETTER = new Propagation.Setter<Map<String, Collection<String>>, String>(){

        @Override
        public void put(Map<String, Collection<String>> carrier, String key, String value) {
            if (!carrier.containsKey(key)) {
                ArrayList values = Lists.newArrayList();
                values.add(value);
                carrier.put(key, values);
            }
        }
    };
    private final Shunt shunt;
    private final Client delegate;
    private Injector<Map<String, Collection<String>>> injector;

    public InjectorFeignClient(Shunt shunt, Client delegate) {
        this.shunt = shunt;
        this.delegate = delegate;
        this.injector = shunt.propagation().injector(SETTER);
    }

    public Response execute(Request request, Request.Options options) throws IOException {
        HashMap headers = Maps.newHashMap((Map)request.headers());
        ShuntContext context = this.shunt.currentShuntContext().get();
        this.injector.inject(context, headers);
        return this.delegate.execute(this.modifiedRequest(request, headers), options);
    }

    private Request modifiedRequest(Request request, Map<String, Collection<String>> headers) {
        Request.HttpMethod method = request.httpMethod();
        String url = request.url();
        Request.Body body = request.requestBody();
        return Request.create((Request.HttpMethod)method, (String)url, headers, (Request.Body)body);
    }
}

