package com.xunyi.rocket;

import com.google.common.collect.Maps;
import org.apache.rocketmq.client.producer.MQProducer;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ReflectionUtils;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RocketClientBeanPostProcessor extends InstantiationAwareBeanPostProcessorAdapter {

    private Map<String, List<Class>> beanToProcessClassMap = Maps.newHashMap();


    @Override
    public Object postProcessBeforeInstantiation(Class<?> beanClass, String beanName) throws BeansException {
        Class clazz = beanClass;
        do {
            for (Field field : beanClass.getDeclaredFields()) {
                if (field.isAnnotationPresent(RocketProducer.class)) {
                    if (!beanToProcessClassMap.containsKey("beanName")) {
                        beanToProcessClassMap.put(beanName, new ArrayList<>());
                    }
                    beanToProcessClassMap.get(beanName).add(clazz);
                }
            }
            clazz = clazz.getSuperclass();
        } while (clazz != null);
        return super.postProcessBeforeInstantiation(beanClass, beanName);
    }

    @Override
    public PropertyValues postProcessProperties(PropertyValues pvs, Object bean, String beanName) throws BeansException {
        if (beanToProcessClassMap.containsKey(beanName)) {
            try {
                Object target = getTargetBean(bean);
                for (Class clazz : beanToProcessClassMap.get(beanName)) {
                    for (Field field : clazz.getDeclaredFields()) {
                        RocketProducer annotation = AnnotationUtils.getAnnotation(field, RocketProducer.class);
                        if (Objects.nonNull(annotation)) {
//                            MQProducer producer = producerFactory.createProducer(annotation.value());
//                            ReflectionUtils.makeAccessible(field);
//                            ReflectionUtils.setField(field, target, producer);
                        }
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return super.postProcessProperties(pvs, bean, beanName);
    }

    private Object getTargetBean(Object bean) throws Exception {
        Object target = bean;
        while (AopUtils.isAopProxy(target)) {
            target = ((Advised) target).getTargetSource().getTarget();
        }
        return target;
    }
}
