package com.xunyi.micro.token;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import lombok.Getter;
import lombok.Setter;

import java.time.Instant;
import java.util.Objects;

/**
 * SNS Token 包装
 */
@JsonTypeInfo(
        use = JsonTypeInfo.Id.NAME,
        include = JsonTypeInfo.As.EXISTING_PROPERTY,
        property = "type",
        visible = true
)
@JsonSubTypes({
        @JsonSubTypes.Type(value = WeixinSNSToken.class, name = "weixin")
})
@Getter @Setter
public class SNSToken implements TokenNamed{

    private static final String NAME = "SNSToken";

    private String type;

    private Instant expireAt;

    protected SNSToken(String type) {
        this.type = type;
    }


    @Override
    public String name() {
        return NAME;
    }
}
