package com.xunyi.micro.token;

import com.xunyi.micro.token.exception.TokenExpiredException;
import lombok.Getter;
import lombok.Setter;

import java.time.Instant;
import java.util.Objects;

@Getter @Setter
public class EmailToken implements TokenNamed{
    private static final String NAME = "EmailToken";

    private String email;

    private Instant expiresAt;

    private Instant issuedAt;

    @Override
    public String name() {
        return NAME;
    }


    private boolean verifyExp(Instant exp, Instant now) {
        return exp.isAfter(now);
    }


    public void verify() {
        Instant now = Instant.now();
        if (!this.verifyExp(this.expiresAt, now)) {
            String msg = "token expired at " + this.getExpiresAt() + ". Current time: " + now;
            throw new TokenExpiredException(msg);
        };
    }
}
