package com.xunyi.micro.shunt.web.servlet;

import com.xunyi.micro.propagation.Propagation;
import com.xunyi.micro.propagation.context.Extractor;
import com.xunyi.micro.shunt.Shunt;
import com.xunyi.micro.shunt.propagation.CurrentShuntContext;
import com.xunyi.micro.shunt.propagation.ShuntContext;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;

public class ShuntFilter implements Filter {

    private CurrentShuntContext currentShuntContext;
    private Extractor<HttpServletRequest> extractor;

    public ShuntFilter(Shunt shunt) {
        this.currentShuntContext = shunt.currentShuntContext();
        this.extractor = shunt.propagation().extractor(GETTER);
    }
    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest) request;
        ShuntContext shuntContext = this.extractor.extract(httpRequest);
        try (CurrentShuntContext.Scope scope = currentShuntContext.newScope(shuntContext)) {
            chain.doFilter(request, response);
        }
    }

    public static final Propagation.Getter<HttpServletRequest, String> GETTER = new Propagation.Getter<HttpServletRequest, String>() {
        @Override
        public String get(HttpServletRequest carrier, String key) {
            return carrier.getHeader(key);
        }
    };
}
