package com.xunyi.micro.shunt.web.client;

import com.xunyi.micro.propagation.Propagation;
import com.xunyi.micro.propagation.context.Injector;
import com.xunyi.micro.shunt.Shunt;
import com.xunyi.micro.shunt.propagation.CurrentShuntContext;
import org.springframework.cloud.gateway.filter.headers.HttpHeadersFilter;
import org.springframework.http.HttpHeaders;
import org.springframework.web.server.ServerWebExchange;


public class ShuntRequestHttpHeadersFilter implements HttpHeadersFilter {

    private static final Propagation.Setter<HttpHeaders, String> SETTER = new Propagation.Setter<HttpHeaders, String>() {
        @Override
        public void put(HttpHeaders carrier, String key, String value) {
            carrier.set(key, value);
        }
    };

    private Injector<HttpHeaders> injector;
    private CurrentShuntContext currentShuntContext;

    public ShuntRequestHttpHeadersFilter(Shunt shunt) {
        this.injector = shunt.propagation().injector(SETTER);
        this.currentShuntContext = shunt.currentShuntContext();
    }

    @Override
    public HttpHeaders filter(HttpHeaders input, ServerWebExchange exchange) {
        HttpHeaders headers = new HttpHeaders();
        headers.addAll(input);
        injector.inject(currentShuntContext.get(), headers);
        return headers;
    }
}
