package com.xunyi.micro.shunt.web;

import com.xunyi.micro.shunt.Shunt;
import com.xunyi.micro.shunt.autoconfig.ShuntAutoConfiguration;
import com.xunyi.micro.shunt.web.servlet.ShuntFilter;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;

import javax.servlet.DispatcherType;

@Configuration
@ConditionalOnProperty(value = "micro.shunt.web.enabled", matchIfMissing = true)
@ConditionalOnWebApplication(type = ConditionalOnWebApplication.Type.SERVLET)
@AutoConfigureAfter(ShuntAutoConfiguration.class)
public class ShuntWebServletAutoConfiguration {

    @Bean
    @ConditionalOnMissingBean
    public ShuntFilter shuntFilter(Shunt shunt) {
        return new ShuntFilter(shunt);
    }

    @Bean
    public FilterRegistrationBean shuntServletFilter(ShuntFilter shuntFilter) {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean<>(shuntFilter);
        filterRegistrationBean.setDispatcherTypes(
                DispatcherType.ASYNC,
                DispatcherType.ERROR, DispatcherType.FORWARD, DispatcherType.INCLUDE,
                DispatcherType.REQUEST
        );
        filterRegistrationBean.setOrder(
                Ordered.HIGHEST_PRECEDENCE + 5
        );
        return filterRegistrationBean;
    }
}
