package com.xunyi.micro.shunt.propagation;


public class ThreadLocalCurrentShuntContext extends CurrentShuntContext{
    private static final ThreadLocal<ShuntContext> DEFAULT = new ThreadLocal<>();
    private static final InheritableThreadLocal<ShuntContext> INHERITABLE = new InheritableThreadLocal<>();

    private final ThreadLocal<ShuntContext> local;


    public static CurrentShuntContext create() {
        return new ThreadLocalCurrentShuntContext(DEFAULT);
    }

    public static CurrentShuntContext createInheritable() {
        return new ThreadLocalCurrentShuntContext(INHERITABLE);
    }

    private ThreadLocalCurrentShuntContext(ThreadLocal<ShuntContext> local) {
        this.local = local;
    }

    @Override
    public ShuntContext get() {
        return this.local.get();
    }

    @Override
    public Scope newScope(ShuntContext current) {
        final ShuntContext previous = local.get();
        local.set(current);
        class DefaultCurrentShuntContextScope implements Scope {
            @Override
            public void close() {
                local.set(previous);
            }
        }
        return new DefaultCurrentShuntContextScope();
    }
}
