package com.xunyi.micro.shunt.propagation;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;

/**
 * 当前分流上下文
 */
public abstract class CurrentShuntContext {


    public abstract ShuntContext get();

    public abstract Scope newScope(ShuntContext current);


    public <C> Callable<C> wrap(Callable<C> task) {
        return task;
    }

    public Runnable wrap(Runnable task) {
        return task;
    }

    public Executor executor(Executor delegate) {
        return delegate;
    }

    public ExecutorService executorService(ExecutorService delegate) {
        return delegate;
    }

    public interface Scope extends AutoCloseable {

        @Override
        void close() throws RuntimeException;
    }
}
