package com.xunyi.micro.shunt.loadbalancer.group;

import com.netflix.loadbalancer.AbstractServerPredicate;
import com.netflix.loadbalancer.PredicateKey;
import com.netflix.loadbalancer.Server;
import org.springframework.lang.Nullable;



public class ServerGroupPredicate extends AbstractServerPredicate {

    private ServerGroupShunting shunting;

    public ServerGroupPredicate(@Nullable ServerGroupShunting shunting) {
        this.shunting = shunting;
    }

    @Override
    public boolean apply(@Nullable PredicateKey predicateKey) {
        Server server = predicateKey.getServer();
        return shunting.apply(server);
    }

}
