package com.xunyi.micro.security.configuration;


import lombok.Getter;
import lombok.Setter;

import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement(name = "pry")
@Getter
@Setter
public class PryProperties {

    @Getter
    @Setter
    public static class PryMapper {

        private String intent;

        private List<String> ips;

        private String policy;

        @XmlElement(name = "ips")
        @XmlJavaTypeAdapter(StringListAdapter.class)
        public void setIps(List<String> ips) {
            this.ips = ips;
        }
    }


    @Getter
    @Setter
    public static class PryPolicy {

        private String name;

        private String clazz;

        private Map<String, String> initParams;

        @XmlElement(name = "class")
        public void setClazz(String clazz) {
            this.clazz = clazz;
        }
        @XmlElement(name = "init-params")
        @XmlJavaTypeAdapter(MapAdapter.class)
        public void setInitParams(Map<String, String> initParams) {
            this.initParams = initParams;
        }
    }

    private List<PryMapper> mapper;
    private List<PryPolicy> policy;


    @Override
    public String toString() {
        return "PryXML{" +
                "mapper=" + mapper +
                ", policy=" + policy +
                '}';
    }
}
