package com.xunyi.micro.propagation;


import com.xunyi.micro.propagation.context.Extractor;
import com.xunyi.micro.propagation.context.Injector;

import java.util.List;

/**
 * 传播
 */
public interface Propagation<K> {

    List<K> keys();

    interface KeyFactory<K> {
        KeyFactory<String> STRING = new Propagation.KeyFactory<String>() {
            @Override
            public String create(String name) {
                return name;
            }
        };

        K create(String name);
    }




    /**
     * 给Carrier
     * @param <C> 载体
     * @param <K> Key
     */
    interface Setter<C, K> {
        void put(C carrier, K key, String value);
    }

    /**
     * @param <C> carrier 载体
     * @return 注入器
     */
    <C> Injector<C> injector(Setter<C, K> setter);



    /**
     *
     * @param <C> 载体
     * @param <K> Key
     */
    interface Getter<C, K>{
        String get(C carrier, K key);
    }

    /**
     * @param <C> 载体
     * @return 提取器
     */
    <C> Extractor<C> extractor(Getter<C, K> getter);
}
