package com.xunyi.micro.message;


import lombok.Getter;

public class ErrorException extends RuntimeException{

    @Getter
    private IError error;

    public ErrorException(IError error) {
        super(error.toString());
        this.error = error;
    }

    public Return<Object> toReturn() {
        return Returns.error(error);
    }

    public boolean is(String errorCode) {
        return this.error.is(errorCode);
    }
}
