package com.xunyi.micro.access.predicate;
import com.xunyi.micro.access.AccessContext;

import java.util.function.Predicate;

public interface PredicateFactory<C> {

    default Class<C> getConfigClass() { throw new UnsupportedOperationException("getConfigClass() not implemented"); }

    default C newConfig() { throw new UnsupportedOperationException("newConfig() not implemented"); }

    Predicate<AccessContext> apply(C config);

    default String name() {return getClass().getSimpleName().replace(PredicateFactory.class.getSimpleName(), "");}

}