/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.micro.web.bind;

import com.xunyi.micro.message.ErrorException;
import com.xunyi.micro.message.IErrorOwner;
import com.xunyi.micro.message.Return;
import com.xunyi.micro.message.StandardErrors;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;

public abstract class AbstractErrorControllerAdvice {
    private static final Logger log = LoggerFactory.getLogger(AbstractErrorControllerAdvice.class);

    public abstract IErrorOwner errorOfCode(String var1) throws Throwable;

    protected IErrorOwner errorOfMessage(String message, IErrorOwner defaultError) {
        try {
            return this.errorOfCode(message);
        }
        catch (Throwable e) {
            log.error("not match error message: ", e);
            return defaultError;
        }
    }

    protected Return returnOfMessage(String message, IErrorOwner defaultError) {
        return this.errorOfMessage(message, defaultError).toReturn();
    }

    protected Return returnOfMessage(String message) {
        return this.returnOfMessage(message, StandardErrors.UNKNOWN_ERROR);
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    @ResponseBody
    public Return constraintViolationException(ConstraintViolationException cve) {
        Set cvs = cve.getConstraintViolations();
        Iterator cvIterator = cvs.iterator();
        ConstraintViolation cs = (ConstraintViolation)cvIterator.next();
        String message = cs.getMessage();
        return this.errorOfMessage(message, StandardErrors.PARAMETER_BAD).toReturn(cs.getPropertyPath().toString());
    }

    protected Return returnOfBindResult(BindingResult bindingResult) {
        FieldError fieldError = bindingResult.getFieldError();
        log.error("returnOfBindResult: Field Error{}", (Object)fieldError);
        assert (fieldError != null);
        String message = fieldError.getDefaultMessage();
        return this.errorOfMessage(message, StandardErrors.PARAMETER_BAD).toReturn(fieldError.getField());
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseBody
    public Return methodArgumentNotValidException(MethodArgumentNotValidException e) {
        log.error("handle MethodArgumentNotValidException", (Throwable)e);
        return this.returnOfBindResult(e.getBindingResult());
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    @ResponseBody
    public Return handleMethodArgumentTypeMismatchException(HttpServletRequest request, MethodArgumentTypeMismatchException e) {
        log.error("handle MissingRequestParameter url:{} name: {}", new Object[]{request.getRequestURI(), e.getName(), e});
        return StandardErrors.PARAMETER_BAD.toReturn(e.getName());
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    @ResponseBody
    public Return handleMissingRequestParameter(HttpServletRequest request, MissingServletRequestParameterException e) {
        log.error("handle MissingRequestParameter url:{} name: {}", new Object[]{request.getRequestURI(), e.getParameterName(), e});
        return StandardErrors.PARAMETER_BAD.toReturn(e.getParameterName());
    }

    @ExceptionHandler(value={BindException.class})
    @ResponseBody
    public Return bindException(BindException e) {
        log.error("handle BindException message:{}", (Object)e.getMessage(), (Object)e);
        return this.returnOfBindResult(e.getBindingResult());
    }

    @ExceptionHandler(value={ErrorException.class})
    @ResponseBody
    public Return handleErrorException(ErrorException e) {
        log.error("handle ErrorException error:{}", (Object)e.getError());
        return e.toReturn();
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public Return handleException(Exception e) {
        log.error("handleException", (Throwable)e);
        return StandardErrors.UNKNOWN_ERROR.toReturn();
    }
}

