/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.micro.slf4j.web;

import brave.http.HttpTracing;
import com.xunyi.micro.slf4j.web.servlet.Slf4jTracingFilter;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.cloud.sleuth.instrument.web.TraceWebServletAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnBean(value={HttpTracing.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@AutoConfigureAfter(value={TraceWebServletAutoConfiguration.class})
public class Slf4jTraceWebServletAutoConfiguration {
    @Bean
    public FilterRegistrationBean<Slf4jTracingFilter> slf4jTraceWebFilter(Slf4jTracingFilter tracingFilter) {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean((Filter)tracingFilter, new ServletRegistrationBean[0]);
        filterRegistrationBean.setDispatcherTypes(DispatcherType.ASYNC, new DispatcherType[]{DispatcherType.ERROR, DispatcherType.FORWARD, DispatcherType.INCLUDE, DispatcherType.REQUEST});
        filterRegistrationBean.setOrder(-2147483642);
        return filterRegistrationBean;
    }

    @Bean
    public Slf4jTracingFilter slf4jTracingFilter(HttpTracing tracing) {
        return Slf4jTracingFilter.create(tracing);
    }
}

