/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.micro.web;

import com.google.common.base.Strings;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class WebUtils {
    private static final Logger log = LogManager.getLogger(WebUtils.class);
    public static final String CACHE_CONTROL_NOCACHE = "no-cache, no-store, private, must-revalidate";
    public static final String HEADER_X_REAL_IP = "X-Real-IP";
    public static final String HEADER_X_FORWARDED_HOST = "X-Forwarded-Host";

    private WebUtils() {
    }

    public static String getForwardedHost(HttpServletRequest request) {
        String host = request.getHeader(HEADER_X_FORWARDED_HOST);
        return host;
    }

    public static String getHost(HttpServletRequest request) {
        String forwardedFor = WebUtils.getForwardedHost(request);
        if (!Strings.isNullOrEmpty((String)forwardedFor) && !"unknown".equalsIgnoreCase(forwardedFor)) {
            int index = forwardedFor.indexOf(44);
            return index != -1 ? forwardedFor.substring(0, index) : forwardedFor;
        }
        return request.getHeader("Host");
    }

    public static void setNoCacheResponse(HttpServletResponse response) {
        response.setHeader("Cache-Control", CACHE_CONTROL_NOCACHE);
    }

    public static String getRealIP(HttpServletRequest request) {
        return request.getHeader(HEADER_X_REAL_IP);
    }

    public static String getIpAddress(HttpServletRequest request) {
        String forwardedFor = request.getHeader("X-Forwarded-For");
        if (!Strings.isNullOrEmpty((String)forwardedFor) && !"unknown".equalsIgnoreCase(forwardedFor)) {
            int index = forwardedFor.indexOf(44);
            return index != -1 ? forwardedFor.substring(0, index) : forwardedFor;
        }
        String realIp = WebUtils.getRealIP(request);
        if (!Strings.isNullOrEmpty((String)realIp) && !"unknown".equalsIgnoreCase(realIp)) {
            return realIp;
        }
        return request.getRemoteAddr();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void response(ServletResponse response, String contentType, String content) {
        PrintWriter out = null;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        httpResponse.setContentType(contentType);
        httpResponse.setCharacterEncoding("UTF-8");
        try {
            out = response.getWriter();
            out.print(content);
        }
        catch (IOException var9) {
            var9.printStackTrace();
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public static void responseJson(ServletResponse response, String json) {
        WebUtils.response(response, "application/json", json);
    }

    public static void responsePlain(ServletResponse response, String text) {
        WebUtils.response(response, "text/plain", text);
    }

    public static boolean isFromForwarded(HttpServletRequest request) {
        String xForwardedFor = request.getHeader("X-Forwarded-For");
        return !Strings.isNullOrEmpty((String)xForwardedFor);
    }

    public static void redirectFile(HttpServletResponse response, String pathString) {
        WebUtils.redirectFile(response, pathString, null);
    }

    public static void redirectFile(HttpServletResponse response, String pathString, String fileName) {
        if (Strings.isNullOrEmpty((String)fileName)) {
            Path path = Paths.get(pathString, new String[0]);
            fileName = String.valueOf(path.getFileName());
        }
        try {
            response.setContentType("application/octet-stream;charset=utf-8");
            response.setHeader("Content-Disposition", "filename=\"" + URLEncoder.encode(fileName, StandardCharsets.UTF_8.toString()) + "\"");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        response.setHeader("X-Accel-Redirect", pathString);
    }

    public static void logHeader(HttpServletRequest request) {
        StringBuilder logBuilder = new StringBuilder();
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            logBuilder.append(name);
            logBuilder.append(request.getHeader(name));
            logBuilder.append("\r\n");
        }
        log.info(logBuilder.toString());
    }
}

