/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.micro.token.support;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.xunyi.micro.token.SNSToken;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SNSTokenCodec {
    private static final Logger log = LoggerFactory.getLogger(SNSTokenCodec.class);
    private static final String CIPHER_TRANSFORMATION = "DESede/ECB/PKCS5Padding";
    private static final String ALGORITHM = "DESede";
    private static final String HEX_KEY = "d983bf671c70409429cedce33801049198a88a621315ce92";
    private static Key SECRET_KEY;
    private static ThreadLocal<Cipher> encryptCipherThreadLocal;
    private static ThreadLocal<Cipher> decryptCipherThreadLocal;
    private static ObjectMapper mapper;

    public static String encode(SNSToken token) {
        try {
            byte[] data = mapper.writeValueAsBytes((Object)token);
            Cipher encryptCipher = encryptCipherThreadLocal.get();
            return Hex.encodeHexString((byte[])encryptCipher.doFinal(data));
        }
        catch (Exception e) {
            log.warn("encode exception", (Throwable)e);
            throw new IllegalStateException();
        }
    }

    public static SNSToken decode(String tokenString) {
        try {
            Cipher decryptCipher = decryptCipherThreadLocal.get();
            byte[] data = decryptCipher.doFinal(Hex.decodeHex((String)tokenString));
            return (SNSToken)mapper.readValue(data, SNSToken.class);
        }
        catch (Exception e) {
            log.warn("decode exception", (Throwable)e);
            throw new IllegalStateException();
        }
    }

    static {
        try {
            byte[] key = Hex.decodeHex((String)HEX_KEY);
            DESedeKeySpec deSedeKeySpec = new DESedeKeySpec(key);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(ALGORITHM);
            SECRET_KEY = secretKeyFactory.generateSecret(deSedeKeySpec);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | DecoderException e) {
            e.printStackTrace();
        }
        encryptCipherThreadLocal = ThreadLocal.withInitial(() -> {
            Cipher encryptCipher = null;
            try {
                encryptCipher = Cipher.getInstance(CIPHER_TRANSFORMATION);
                encryptCipher.init(1, SECRET_KEY);
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
                e.printStackTrace();
            }
            return encryptCipher;
        });
        decryptCipherThreadLocal = ThreadLocal.withInitial(() -> {
            Cipher decryptCipher = null;
            try {
                decryptCipher = Cipher.getInstance(CIPHER_TRANSFORMATION);
                decryptCipher.init(2, SECRET_KEY);
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
                e.printStackTrace();
            }
            return decryptCipher;
        });
        mapper = new ObjectMapper();
    }
}

