/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.micro.shunt.propagation;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.xunyi.micro.propagation.Propagation;
import com.xunyi.micro.propagation.context.PropagationContext;
import com.xunyi.micro.propagation.inject.Extractor;
import com.xunyi.micro.propagation.inject.Getter;
import com.xunyi.micro.propagation.inject.Injector;
import com.xunyi.micro.propagation.inject.KeyFactory;
import com.xunyi.micro.propagation.inject.Setter;
import com.xunyi.micro.shunt.propagation.ShuntContext;
import java.util.Collections;
import java.util.List;

public class ShuntPropagation<K>
implements Propagation<K> {
    private final K sequencesKey;
    private final List<K> fields;

    public ShuntPropagation(KeyFactory<K> keyFactory) {
        this.sequencesKey = keyFactory.create("sequences");
        this.fields = Collections.unmodifiableList(Collections.singletonList(this.sequencesKey));
    }

    @Override
    public List<K> keys() {
        return this.fields;
    }

    @Override
    public <C> Injector<C> injector(Setter<C, K> setter) {
        return new InnerInjector(this, setter);
    }

    static final class InnerExtractor<C, K>
    implements Extractor<C> {
        private ShuntPropagation<K> propagation;
        private Getter<C, K> getter;

        public InnerExtractor(ShuntPropagation<K> propagation, Getter<C, K> getter) {
            this.propagation = propagation;
            this.getter = getter;
        }

        @Override
        public PropagationContext extract(C carrier) {
            String sequencesString = this.getter.get(carrier, ((ShuntPropagation)this.propagation).sequencesKey);
            List sequences = Splitter.on((String)",").splitToList((CharSequence)sequencesString);
            return new ShuntContext(sequences);
        }
    }

    static final class InnerInjector<C, K>
    implements Injector<C> {
        private ShuntPropagation<K> propagation;
        private Setter<C, K> setter;

        private InnerInjector(ShuntPropagation<K> propagation, Setter<C, K> setter) {
            this.propagation = propagation;
            this.setter = setter;
        }

        @Override
        public <T extends PropagationContext> void inject(T context, C carrier) {
            ShuntContext shuntContext = (ShuntContext)context;
            this.setter.put(carrier, ((ShuntPropagation)this.propagation).sequencesKey, Joiner.on((String)",").join(shuntContext.sequences()));
        }
    }
}

