/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.micro.propagation.web.client.feign;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xunyi.micro.propagation.inject.Setter;
import feign.Client;
import feign.Request;
import feign.Response;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InjectorFeignClient
implements Client {
    private static final Logger log = LoggerFactory.getLogger(InjectorFeignClient.class);
    static final Setter<Map<String, Collection<String>>, String> SETTER = new Setter<Map<String, Collection<String>>, String>(){

        @Override
        public void put(Map<String, Collection<String>> carrier, String key, String value) {
            if (!carrier.containsKey(key)) {
                ArrayList values = Lists.newArrayList();
                values.add(value);
                carrier.put(key, values);
            }
        }
    };
    private final Client delegate;

    public InjectorFeignClient(Client delegate) {
        this.delegate = delegate;
    }

    public Response execute(Request request, Request.Options options) throws IOException {
        HashMap headers = Maps.newHashMap((Map)request.headers());
        return this.delegate.execute(this.modifiedRequest(request, headers), options);
    }

    private Request modifiedRequest(Request request, Map<String, Collection<String>> headers) {
        String method = request.method();
        String url = request.url();
        byte[] body = request.body();
        Charset charset = request.charset();
        return Request.create((String)method, (String)url, headers, (byte[])body, (Charset)charset);
    }
}

