/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.micro.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.mongodb.MongoClient;
import com.xunyi.micro.data.repository.mongo.MongoModule;
import com.xunyi.micro.message.jackson.MessageModule;
import com.xunyi.money.jackson.MoneyModule;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;

@Configuration
@ConditionalOnClass(value={ObjectMapper.class})
public class JacksonCustomerConfiguration {
    @Bean
    @ConditionalOnClass(value={Jackson2ObjectMapperBuilder.class})
    public Jackson2ObjectMapperBuilderCustomizer customizer() {
        return jacksonObjectMapperBuilder -> {
            jacksonObjectMapperBuilder.serializationInclusion(JsonInclude.Include.NON_NULL);
            jacksonObjectMapperBuilder.featuresToDisable(new Object[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false});
            jacksonObjectMapperBuilder.featuresToDisable(new Object[]{DeserializationFeature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS, false});
        };
    }

    @Bean
    @ConditionalOnClass(value={Jackson2ObjectMapperBuilder.class})
    @ConditionalOnBean(value={MessageSource.class})
    public MessageModule messageModule(MessageSource source) {
        return new MessageModule(source);
    }

    @Bean
    @ConditionalOnClass(value={Jackson2ObjectMapperBuilder.class})
    @ConditionalOnBean(value={MongoClient.class})
    public MongoModule mongoModule() {
        return new MongoModule();
    }

    @Bean
    @ConditionalOnClass(value={Jackson2ObjectMapperBuilder.class})
    @ConditionalOnBean(value={MongoClient.class})
    public MoneyModule moneyModule() {
        return new MoneyModule();
    }
}

