/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.micro.data.repository.mongo;

import com.xunyi.micro.data.page.Page;
import com.xunyi.micro.data.repository.mongo.support.PageableExecutionUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.repository.query.MongoEntityInformation;
import org.springframework.data.mongodb.repository.support.MongoRepositoryFactory;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;

@Deprecated
public class AbsMongoRepository<T, ID extends Serializable> {
    protected final Class<T> entityClass;
    protected MongoOperations mongoOperations;
    protected MongoEntityInformation<T, ID> entityInformation;

    public AbsMongoRepository() {
        this(null);
    }

    public AbsMongoRepository(Class<T> clazz) {
        if (clazz == null) {
            Class<?> repositoryInterface = this.getClass();
            List arguments = ClassTypeInformation.from(repositoryInterface).getRequiredSuperTypeInformation(AbsMongoRepository.class).getTypeArguments();
            clazz = AbsMongoRepository.resolveTypeParameter(arguments, 0, () -> String.format("Could not resolve domain type of %s!", repositoryInterface));
        }
        this.entityClass = clazz;
    }

    private static Class<?> resolveTypeParameter(List<TypeInformation<?>> arguments, int index, Supplier<String> exceptionMessage) {
        if (arguments.size() <= index || arguments.get(index) == null) {
            throw new IllegalArgumentException(exceptionMessage.get());
        }
        return arguments.get(index).getType();
    }

    @Autowired
    public void setMongoOperations(MongoOperations mongoOperations) {
        this.mongoOperations = mongoOperations;
    }

    @Autowired
    public void setMongoRepositoryFactory(MongoRepositoryFactory factory) {
        this.entityInformation = factory.getEntityInformation(this.entityClass);
    }

    @PostConstruct
    public void init() {
    }

    public List<T> find(Query query) {
        return this.mongoOperations.find(query, this.entityInformation.getJavaType());
    }

    public Page<T> find(final Query query, Pageable pageable) {
        query.with(pageable);
        List list = this.mongoOperations.find(query, this.entityInformation.getJavaType(), this.entityInformation.getCollectionName());
        return PageableExecutionUtils.getPage(list, pageable, new PageableExecutionUtils.TotalSupplier(){

            @Override
            public long get() {
                return AbsMongoRepository.this.mongoOperations.count(query, AbsMongoRepository.this.entityInformation.getJavaType(), AbsMongoRepository.this.entityInformation.getCollectionName());
            }
        });
    }

    public <S extends T> S save(S entity) {
        Assert.notNull(entity, (String)"Entity must not be null!");
        if (this.entityInformation.isNew(entity)) {
            this.mongoOperations.insert(entity, this.entityInformation.getCollectionName());
        } else {
            this.mongoOperations.save(entity, this.entityInformation.getCollectionName());
        }
        return entity;
    }

    public <S extends T> List<S> save(Iterable<S> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities not be null!");
        List<S> result = AbsMongoRepository.convertIterableToList(entities);
        boolean allNew = true;
        for (S entity : entities) {
            if (!allNew || this.entityInformation.isNew(entity)) continue;
            allNew = false;
        }
        if (allNew) {
            this.mongoOperations.insertAll(result);
        } else {
            for (S entity : result) {
                this.save((Iterable)entity);
            }
        }
        return result;
    }

    public T findOne(ID id) {
        Assert.notNull(id, (String)"The given id must not be null!");
        return (T)this.mongoOperations.findById(id, this.entityInformation.getJavaType(), this.entityInformation.getCollectionName());
    }

    private Query getIdQuery(Object id) {
        return new Query((CriteriaDefinition)this.getIdCriteria(id));
    }

    private Criteria getIdCriteria(Object id) {
        return Criteria.where((String)this.entityInformation.getIdAttribute()).is(id);
    }

    public boolean exists(ID id) {
        Assert.notNull(id, (String)"The given id must not be null!");
        return this.mongoOperations.exists(this.getIdQuery(id), this.entityInformation.getJavaType(), this.entityInformation.getCollectionName());
    }

    public long count() {
        return this.mongoOperations.getCollection(this.entityInformation.getCollectionName()).count();
    }

    public void delete(ID id) {
        Assert.notNull(id, (String)"The given id must not be null!");
        this.mongoOperations.remove(this.getIdQuery(id), this.entityInformation.getJavaType(), this.entityInformation.getCollectionName());
    }

    public void delete(T entity) {
        Assert.notNull(entity, (String)"The given entity must not be null!");
        this.delete((T)((Serializable)this.entityInformation.getId(entity)));
    }

    public void delete(Iterable<? extends T> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities not be null!");
        for (T entity : entities) {
            this.delete(entity);
        }
    }

    public void deleteAll() {
        this.mongoOperations.remove(new Query(), this.entityInformation.getCollectionName());
    }

    public List<T> findAll() {
        return this.findAll(new Query());
    }

    public Iterable<T> findAll(Iterable<ID> ids) {
        HashSet<Serializable> parameters = new HashSet<Serializable>(AbsMongoRepository.tryDetermineRealSizeOrReturn(ids, 10));
        for (Serializable id : ids) {
            parameters.add(id);
        }
        return this.findAll(new Query((CriteriaDefinition)new Criteria(this.entityInformation.getIdAttribute()).in(parameters)));
    }

    public <S extends T> S insert(S entity) {
        Assert.notNull(entity, (String)"Entity must not be null!");
        this.mongoOperations.insert(entity, this.entityInformation.getCollectionName());
        return entity;
    }

    public <S extends T> List<S> insert(Iterable<S> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities not be null!");
        List<S> list = AbsMongoRepository.convertIterableToList(entities);
        if (list.isEmpty()) {
            return list;
        }
        this.mongoOperations.insertAll(list);
        return list;
    }

    private List<T> findAll(Query query) {
        return query == null ? Collections.emptyList() : this.mongoOperations.find(query, this.entityInformation.getJavaType(), this.entityInformation.getCollectionName());
    }

    private static <T> List<T> convertIterableToList(Iterable<T> entities) {
        if (entities instanceof List) {
            return (List)entities;
        }
        int capacity = AbsMongoRepository.tryDetermineRealSizeOrReturn(entities, 10);
        if (capacity != 0 && entities != null) {
            ArrayList<T> list = new ArrayList<T>(capacity);
            for (T entity : entities) {
                list.add(entity);
            }
            return list;
        }
        return Collections.emptyList();
    }

    private static int tryDetermineRealSizeOrReturn(Iterable<?> iterable, int defaultSize) {
        return iterable == null ? 0 : (iterable instanceof Collection ? ((Collection)iterable).size() : defaultSize);
    }

    public <S extends T> Page<S> findAll(Example<S> example, Pageable pageable) {
        Assert.notNull(example, (String)"Sample must not be null!");
        Assert.notNull((Object)pageable, (String)"Pageable must not be null!");
        Query q = new Query((CriteriaDefinition)new Criteria().alike(example)).with(pageable);
        List list = this.mongoOperations.find(q, example.getProbeType(), this.entityInformation.getCollectionName());
        return PageableExecutionUtils.getPage(list, pageable, () -> this.mongoOperations.count(q, example.getProbeType(), this.entityInformation.getCollectionName()));
    }

    public <S extends T> List<S> findAll(Example<S> example, Sort sort) {
        Assert.notNull(example, (String)"Sample must not be null!");
        Assert.notNull((Object)sort, (String)"Sort must not be null!");
        Query q = new Query((CriteriaDefinition)new Criteria().alike(example)).with(sort);
        return this.mongoOperations.find(q, example.getProbeType(), this.entityInformation.getCollectionName());
    }

    public <S extends T> List<S> findAll(Example<S> example) {
        return this.findAll(example, Sort.unsorted());
    }

    public <S extends T> Optional<S> findOne(Example<S> example) {
        Assert.notNull(example, (String)"Sample must not be null!");
        Query q = new Query((CriteriaDefinition)new Criteria().alike(example));
        return Optional.ofNullable(this.mongoOperations.findOne(q, example.getProbeType(), this.entityInformation.getCollectionName()));
    }

    public <S extends T> long count(Example<S> example) {
        Assert.notNull(example, (String)"Sample must not be null!");
        Query q = new Query((CriteriaDefinition)new Criteria().alike(example));
        return this.mongoOperations.count(q, example.getProbeType(), this.entityInformation.getCollectionName());
    }

    public <S extends T> boolean exists(Example<S> example) {
        Assert.notNull(example, (String)"Sample must not be null!");
        Query q = new Query((CriteriaDefinition)new Criteria().alike(example));
        return this.mongoOperations.exists(q, example.getProbeType(), this.entityInformation.getCollectionName());
    }
}

