/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.micro.token;

import com.xunyi.micro.token.XYClaims;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Header;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.JwtHandlerAdapter;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;

public class XYJwt {
    private XYClaims claims;

    public XYClaims getClaims() {
        return this.claims;
    }

    public void setClaims(XYClaims claims) {
        this.claims = claims;
    }

    static class JwtAdapter
    extends JwtHandlerAdapter<XYJwt> {
        JwtAdapter() {
        }

        public XYJwt onClaimsJws(Jws<Claims> jws) {
            JwsHeader header = (JwsHeader)jws.getHeader();
            Claims claims = (Claims)jws.getBody();
            XYClaims xyClaims = new XYClaims();
            xyClaims.setUid(((Number)claims.get("xy_uid", Number.class)).longValue());
            xyClaims.setIssuedAt(Instant.ofEpochSecond((Long)claims.get("iss", Long.class)));
            xyClaims.setExpiresAt(((Date)claims.get("exp", Date.class)).toInstant());
            Instant now = Instant.now();
            if (!xyClaims.verifyExpiresAt(now, false)) {
                Duration duration = Duration.between(xyClaims.getExpiresAt(), now);
                String msg = "JWT expired at " + xyClaims.getExpiresAt() + ". Current time: " + now;
                throw new ExpiredJwtException((Header)header, claims, msg);
            }
            XYJwt jwt = new XYJwt();
            jwt.setClaims(xyClaims);
            return jwt;
        }
    }
}

