/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.micro.grpc;

import com.google.common.collect.Lists;
import com.xunyi.micro.grpc.GRPCChannelFactory;
import com.xunyi.micro.grpc.GRPCChannelsProperties;
import com.xunyi.micro.grpc.GRPCClient;
import com.xunyi.micro.grpc.GRPCClientBeanPostProcessor;
import com.xunyi.micro.grpc.discovery.DiscoveryChannelFactory;
import com.xunyi.micro.grpc.sleuth.TraceClientInterceptor;
import io.grpc.LoadBalancer;
import io.grpc.util.RoundRobinLoadBalancerFactory;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.consul.discovery.ConsulDiscoveryClientConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={GRPCChannelsProperties.class})
@ConditionalOnClass(value={GRPCChannelFactory.class, LoadBalancer.class})
@AutoConfigureAfter(value={ConsulDiscoveryClientConfiguration.class})
@ConditionalOnBean(value={DiscoveryClient.class})
public class GRPCDiscoveryAutoConfiguration {
    @ConditionalOnMissingBean
    @Bean
    public LoadBalancer.Factory grpcLoadBalancerFactory() {
        return RoundRobinLoadBalancerFactory.getInstance();
    }

    @Bean
    @ConditionalOnClass(value={GRPCClient.class})
    public GRPCClientBeanPostProcessor clientBeanPostProcessor() {
        return new GRPCClientBeanPostProcessor();
    }

    @Bean
    public GRPCChannelFactory discoveryClientChannelFactory(GRPCChannelsProperties properties, DiscoveryClient discoveryClient, LoadBalancer.Factory loadBalancerFactory, @Autowired(required=false) TraceClientInterceptor interceptor) {
        ArrayList interceptors = Lists.newArrayList();
        if (interceptor != null) {
            interceptors.add(interceptor);
        }
        return new DiscoveryChannelFactory(properties, discoveryClient, loadBalancerFactory, interceptors);
    }
}

