/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.micro.data.utils;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;

public class ClassUtils {
    public static Class<?> findParametrizedClass(Class<?> thisClass, Class<?> parametrizedSuperclass, String typeParamName) {
        Class<?> currentClass = thisClass;
        while (true) {
            if (currentClass.getSuperclass() != parametrizedSuperclass) {
                if ((currentClass = currentClass.getSuperclass()) != null) continue;
                return ClassUtils.fail(thisClass, typeParamName);
            }
            int typeParamIndex = -1;
            TypeVariable<Class<?>>[] typeParams = currentClass.getSuperclass().getTypeParameters();
            for (int i = 0; i < typeParams.length; ++i) {
                if (!typeParamName.equals(typeParams[i].getName())) continue;
                typeParamIndex = i;
                break;
            }
            if (typeParamIndex < 0) {
                throw new IllegalStateException("unknown type parameter '" + typeParamName + "': " + parametrizedSuperclass);
            }
            Type genericSuperType = currentClass.getGenericSuperclass();
            if (!(genericSuperType instanceof ParameterizedType)) {
                return Object.class;
            }
            Type[] actualTypeParams = ((ParameterizedType)genericSuperType).getActualTypeArguments();
            Type actualTypeParam = actualTypeParams[typeParamIndex];
            if (actualTypeParam instanceof ParameterizedType) {
                actualTypeParam = ((ParameterizedType)actualTypeParam).getRawType();
            }
            if (actualTypeParam instanceof Class) {
                return (Class)actualTypeParam;
            }
            if (actualTypeParam instanceof GenericArrayType) {
                Type componentType = ((GenericArrayType)actualTypeParam).getGenericComponentType();
                if (componentType instanceof ParameterizedType) {
                    componentType = ((ParameterizedType)componentType).getRawType();
                }
                if (componentType instanceof Class) {
                    return Array.newInstance((Class)componentType, 0).getClass();
                }
            }
            if (!(actualTypeParam instanceof TypeVariable)) {
                return ClassUtils.fail(thisClass, typeParamName);
            }
            TypeVariable v = (TypeVariable)actualTypeParam;
            currentClass = thisClass;
            if (!(v.getGenericDeclaration() instanceof Class)) {
                return Object.class;
            }
            parametrizedSuperclass = (Class)v.getGenericDeclaration();
            typeParamName = v.getName();
            if (!parametrizedSuperclass.isAssignableFrom(thisClass)) break;
        }
        return Object.class;
    }

    private static Class<?> fail(Class<?> type, String typeParamName) {
        throw new IllegalStateException("cannot determine the type of the type parameter '" + typeParamName + "': " + type);
    }
}

