/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.micro.data.transformer;

import com.xunyi.micro.data.utils.ClassUtils;
import java.util.function.Function;
import org.springframework.beans.BeanUtils;

public class BeanCopyFunction<I, O>
implements Function<I, O> {
    protected final Class<O> entityClass;

    public BeanCopyFunction() {
        this(null);
    }

    public BeanCopyFunction(Class<O> clazz) {
        this.entityClass = clazz != null ? clazz : ClassUtils.findParametrizedClass(this.getClass(), BeanCopyFunction.class, "O");
    }

    private O newOutputInstance() {
        return (O)BeanUtils.instantiateClass(this.entityClass);
    }

    @Override
    public O apply(I input) {
        O output = this.newOutputInstance();
        assert (output != null);
        BeanUtils.copyProperties(input, output);
        return output;
    }
}

