/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.micro.data.page;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Page<T>
implements Iterable<T> {
    private static Page EMPTY_PAGE = new Page(Collections.emptyList(), 0);
    private Collection<T> rows;
    private long total;

    public static <T> Page<T> emptyPage() {
        return EMPTY_PAGE;
    }

    public Page() {
    }

    public Page(Collection<T> rows, long total) {
        this.rows = rows;
        this.total = total;
    }

    public Page(Collection<T> rows, int total) {
        this.rows = rows;
        this.total = total;
    }

    public Page(Integer total) {
        this.rows = null;
        this.total = total.intValue();
    }

    public Collection<T> getRows() {
        return this.rows;
    }

    public void setRows(List<T> rows) {
        this.rows = rows;
    }

    public long getTotal() {
        return this.total;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    @Override
    public Iterator<T> iterator() {
        return this.rows.iterator();
    }

    public <R> Page<R> map(Function<T, R> function) {
        List rows = this.rows.stream().map(function).collect(Collectors.toList());
        return new Page(rows, this.total);
    }

    public String toString() {
        return "Page(rows=" + this.getRows() + ", total=" + this.getTotal() + ")";
    }
}

