package com.xunyi.micro.token;

import io.jsonwebtoken.Claims;
import lombok.Getter;
import lombok.Setter;

import java.time.Duration;
import java.time.Instant;

@Getter @Setter
public class XYClaims  {
    private long uid;
    private Instant issuedAt;
    private Instant expiresAt;

    //注意验证有效

    private boolean verifyExp(Instant exp, Instant now, boolean required) {
        if (exp == null) {
            return !required;
        }
        return exp.isAfter(now);
    }
    public boolean verifyExpiresAt(Instant cmp, boolean required) {
        return this.verifyExp(this.expiresAt, cmp, required);
    }

    public boolean valid() {
        Instant now = Instant.now();
        if (this.verifyExpiresAt(now, false)) {
            Duration duration = Duration.between(this.expiresAt, now);
            //过期了多久 duration.toSeconds()

        }
        return false;
    }
}
