package com.xunyi.micro.grpc;


import com.xunyi.micro.grpc.discovery.DiscoveryChannelFactory;
import com.xunyi.micro.grpc.sleuth.MetadataInjector;
import com.xunyi.micro.grpc.sleuth.TraceClientInterceptor;
import io.grpc.LoadBalancer;
import io.grpc.util.RoundRobinLoadBalancerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value = GRPCChannelsProperties.class)
@ConditionalOnClass({GRPCChannelFactory.class})
public class GRPCDiscoveryAutoConfiguration {

    @ConditionalOnMissingBean
    @Bean
    public GRPCChannelsProperties properties() {
        return new GRPCChannelsProperties();
    }

    @ConditionalOnMissingBean
    @Bean
    public LoadBalancer.Factory grpcLoadBalancerFactory() {
        return RoundRobinLoadBalancerFactory.getInstance();
    }

    @Bean
    @ConditionalOnClass(GRPCClient.class)
    public GRPCClientBeanPostProcessor clientBeanPostProcessor() {
        return new GRPCClientBeanPostProcessor();
    }

    @Configuration
    @ConditionalOnBean({org.springframework.cloud.client.discovery.DiscoveryClient.class})
    protected static class DiscoveryGRPCClientAutoConfiguration {
        protected DiscoveryGRPCClientAutoConfiguration() {
        }

        @ConditionalOnMissingBean
        @Bean
        public GRPCChannelFactory discoveryClientChannelFactory(GRPCChannelsProperties properties,
                                                                DiscoveryClient discoveryClient,
                                                                LoadBalancer.Factory loadBalancerFactory,
                                                                @Autowired(required = false) TraceClientInterceptor interceptor) {
            return new DiscoveryChannelFactory(properties, discoveryClient, loadBalancerFactory, interceptor);
        }
    }

    @Configuration
//    @ConditionalOnBean({org.springframework.cloud.sleuth.Tracer.class}) //这个不生效
    protected static class TracerAutoConfiguration {


        @ConditionalOnMissingBean
        @Bean
        public TraceClientInterceptor interceptor(Tracer tracer) {
            return new TraceClientInterceptor(tracer, new MetadataInjector());
        }

    }
}
