package com.xunyi.micro.token;


import io.jsonwebtoken.*;
import lombok.Getter;
import lombok.Setter;

import java.time.Instant;

/**
 * Token 包装
 * parse
 * 基础信息维护
 */
@Getter @Setter
public class XYToken {

    public static final String COOKIE_NAME = "xy-token";
    private long uid;
    private Instant issuedAt;
    private Instant expiresAt;

    private XYToken() {

    }

    private static JwtParser jwtParser = Jwts.parser().setSigningKey("");


    private static XYJwt.JwtAdapter adapter = new XYJwt.JwtAdapter();


    public static XYToken parseToken(String tokenString) {
        XYJwt jwt = jwtParser.parse(tokenString, adapter);
        XYClaims claims = jwt.getClaims();
        XYToken token = new XYToken();
        token.setUid(claims.getUid());
        token.setExpiresAt(claims.getExpiresAt());
        token.setIssuedAt(claims.getIssuedAt());
        return token;
    }
}
