package com.xunyi.micro.message;

/*
 * web passport
 * 通用错误代码
 * 错误代码范围  10000 < CODE < 110000
 */
public enum  Errors implements IError {

    UNKNOWN_ERROR(),

    ;
    private String errorCode;

    Errors() {
        this.errorCode = this.name();
    }

    public static Errors valueOfMessage(String message) {
        try {
            return Errors.valueOf(message);
        } catch (Exception e) {
            return UNKNOWN_ERROR;
        }
    }

    @Override
    public String getErrorCode() {
        return this.errorCode;
    }

//    @Override
//    public String getType() {
//        return this.name();
//    }


    @Override
    public Return toReturn() {
        XYError error = new XYError(this.getErrorCode());
        return Returns.error(error);
    }
    @Override
    public ErrorException toException() {
        XYError error = new XYError(this.getErrorCode());
        return new ErrorException(error);
    }

}
