package com.xunyi.micro.grpc.sleuth;

import io.grpc.Metadata;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanInjector;

import java.util.List;
import java.util.Map;

public class MetadataInjector implements SpanInjector<Metadata> {
    private static final String BAGGAGE_HEADER_PREFIX = Span.SPAN_BAGGAGE_HEADER_PREFIX + "-";
    @Override
    public void inject(Span span, Metadata carrier) {
        setMetadata(carrier, Span.TRACE_ID_NAME, Span.idToHex(span.getTraceId()));
        setMetadata(carrier, Span.SPAN_ID_NAME, Span.idToHex(span.getSpanId()));
        setMetadata(carrier, Span.SAMPLED_NAME, span.isExportable() ? Span.SPAN_SAMPLED : Span.SPAN_NOT_SAMPLED);

        List<Long> parents = span.getParents();
        if (CollectionUtils.isNotEmpty(parents)) {
            Long parentId = parents.get(0);
            setMetadata(carrier, Span.PARENT_ID_NAME, Span.idToHex(parentId));
        }
        for (Map.Entry<String, String> entry : span.baggageItems()) {
            setMetadata(carrier, BAGGAGE_HEADER_PREFIX + entry.getKey(), entry.getValue());
        }
    }

    private void setMetadata(Metadata metadata, String name, String value) {
        metadata.put(Metadata.Key.of(name, Metadata.ASCII_STRING_MARSHALLER), value);
    }




}
