/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.micro.token;

import com.xunyi.micro.token.XYClaims;
import com.xunyi.micro.token.XYJwt;
import io.jsonwebtoken.JwtHandler;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import java.time.Instant;

public class XYToken {
    public static final String COOKIE_NAME = "xy-token";
    private long uid;
    private Instant issuedAt;
    private Instant expiresAt;
    private static JwtParser jwtParser = Jwts.parser().setSigningKey("");
    private static XYJwt.JwtAdapter adapter = new XYJwt.JwtAdapter();

    private XYToken() {
    }

    public static XYToken parseToken(String tokenString) {
        XYJwt jwt = (XYJwt)jwtParser.parse(tokenString, (JwtHandler)adapter);
        XYClaims claims = jwt.getClaims();
        XYToken token = new XYToken();
        token.setUid(claims.getUid());
        token.setExpiresAt(claims.getExpiresAt());
        token.setIssuedAt(claims.getIssuedAt());
        return token;
    }

    public long getUid() {
        return this.uid;
    }

    public Instant getIssuedAt() {
        return this.issuedAt;
    }

    public Instant getExpiresAt() {
        return this.expiresAt;
    }

    public void setUid(long uid) {
        this.uid = uid;
    }

    public void setIssuedAt(Instant issuedAt) {
        this.issuedAt = issuedAt;
    }

    public void setExpiresAt(Instant expiresAt) {
        this.expiresAt = expiresAt;
    }
}

