/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.micro.grpc.sleuth;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanInjector;
import org.springframework.cloud.sleuth.Tracer;

public class TraceClientInterceptor
implements ClientInterceptor {
    private Tracer tracer;
    private SpanInjector<Metadata> spanInjector;

    public TraceClientInterceptor(Tracer tracer, SpanInjector<Metadata> spanInjector) {
        this.tracer = tracer;
        this.spanInjector = spanInjector;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(final MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        return new ClientInterceptors.CheckedForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

            protected void checkedStart(ClientCall.Listener<RespT> listener, Metadata metadata) throws Exception {
                Span parentSpan = TraceClientInterceptor.this.tracer.getCurrentSpan();
                String operationName = method.getFullMethodName();
                final Span span = TraceClientInterceptor.this.tracer.createSpan(operationName, parentSpan);
                TraceClientInterceptor.this.spanInjector.inject(span, (Object)metadata);
                this.delegate().start((ClientCall.Listener)new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(listener){

                    public void onReady() {
                        span.logEvent("cs");
                        super.onReady();
                    }

                    public void onMessage(RespT message) {
                        span.logEvent("cr");
                        TraceClientInterceptor.this.tracer.close(span);
                        super.onMessage(message);
                    }
                }, metadata);
            }
        };
    }
}

