/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.micro.grpc.sleuth;

import io.grpc.Metadata;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanInjector;

public class MetadataInjector
implements SpanInjector<Metadata> {
    private static final String BAGGAGE_HEADER_PREFIX = "baggage-";

    public void inject(Span span, Metadata carrier) {
        this.setMetadata(carrier, "X-B3-TraceId", Span.idToHex((long)span.getTraceId()));
        this.setMetadata(carrier, "X-B3-SpanId", Span.idToHex((long)span.getSpanId()));
        this.setMetadata(carrier, "X-B3-Sampled", span.isExportable() ? "1" : "0");
        List parents = span.getParents();
        if (CollectionUtils.isNotEmpty((Collection)parents)) {
            Long parentId = (Long)parents.get(0);
            this.setMetadata(carrier, "X-B3-ParentSpanId", Span.idToHex((long)parentId));
        }
        for (Map.Entry entry : span.baggageItems()) {
            this.setMetadata(carrier, BAGGAGE_HEADER_PREFIX + (String)entry.getKey(), (String)entry.getValue());
        }
    }

    private void setMetadata(Metadata metadata, String name, String value) {
        metadata.put(Metadata.Key.of((String)name, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)value);
    }
}

