package com.xunyi.niux.compatible.client;


import com.xunyi.beast.data.message.Return;
import com.xunyi.beast.data.message.ReturnResult;
import com.xunyi.niux.compatible.client.dto.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

import static org.springframework.web.bind.annotation.RequestMethod.GET;

@FeignClient("niux-compatible")
public interface NiuxCompatibleClient {

    @GetMapping("/api/users/{userId}")
    ReturnResult<UserinfoOutput> user(@PathVariable("userId") String userId);

    // 创建游戏
    @PostMapping("/api/games/create")
    ReturnResult<GameInfo> createGame(@RequestBody CreateGameInput input);

    // 修改游戏
    @PostMapping("/api/games/edit")
    ReturnResult<GameInfo> editGame(@RequestBody EditGameInput input);

    // 修改游戏币
    @PostMapping("/api/games/editgamemoney")
    ReturnResult<GameInfo> editGameMoney(@RequestBody EditGameMoneyInput input);

    // 根据游戏ID查询游戏信息
    @GetMapping("/api/games/{gameId}")
    ReturnResult<GameInfo> getGameInfoById(
            @PathVariable("gameId") String gameId
    );

    //创建游戏-订单
    @PostMapping("/api/game/{gameId}/orders")
    ReturnResult<CreateGameOrderOutput> createGameOrder(
            @PathVariable("gameId") String gameId,
            @RequestBody CreateGameOrderInput input);

    @PostMapping("/api/game/{gameId}/orders/{orderNo}/preorder")
    ReturnResult<CreateGameOrderOutput> preorderGameOrder(
            @PathVariable("gameId") String gameId,
            @PathVariable("orderNo") String orderNo,
            @RequestBody CreateGameOrderInput input);

    //查询游戏订单
    @GetMapping("/api/game-orders/{orderNo}")
    ReturnResult<GameOrder> getOrder(
            @PathVariable("orderNo") String orderNo
    );

    // 支付回调
    @PostMapping(value = "/api/game/pay/callback", consumes = {"application/x-www-form-urlencoded"})
    String gamePayCallBack(MultiValueMap<String, String> input);

    // 查询游戏区服信息
    @GetMapping("/api/games/{gameId}/servers/{serverId}")
    ReturnResult<GameServer> getGameServerBy(@PathVariable("gameId") String gameId,
                                             @PathVariable("serverId") Integer serverId);

    @GetMapping("/api/players/{userId}")
    ReturnResult<NiuXPlayer> getPlayer(@PathVariable("userId") String userId);

    // 查询玩家游戏账号
    @GetMapping("/api/players/{userId}/games/{gameId}/account")
    ReturnResult<PlayerOpenId> getPlayerOpenId(@PathVariable("userId") String userId,
                                               @PathVariable("gameId") String gameId);

    // 根据用户游戏id和游戏id查询用户的牛X平台userid", notes = "根据用户游戏id和游戏id查询用户的牛X平台userid")
    @GetMapping("/api/players/customer/{customerId}/games/{gameId}/account")
    ReturnResult<UserIdOutput> getUserId(@PathVariable("customerId") String customerId,
                                         @PathVariable("gameId") String gameId);


    // 查询魔域玩家 vip信息
    @GetMapping("/api/games/000001/players/{userId}/vip")
    ReturnResult<MoyuVip> getMoyuPlayerVip(@PathVariable("userId") String userId);


    //--------游戏备案识别码接口---------------------
    // 添加游戏备案识别码
    @PostMapping("/api/fcm/addbizid")
    Return addGameBizId(@RequestParam Map<String, String> params);

    // 修改游戏备案识别码
    @PostMapping("/api/fcm/editbizid")
    Return editGameBizId(@RequestParam Map<String, String> params);

    // 查询游戏备案识别码
    @GetMapping(path = "/api/fcm/querybizid/{gameId}")
    ReturnResult<GamesFcmOutput> queryGameBizId(@PathVariable("gameId") String gameId);


    //------------------实名认证接口-------------------

    // 调用国家实名认证接口进行实名认证，返回实名认证标识pi
    @GetMapping("/api/fcm/authencheck/{gameid}/{userno}/{openid}")
    ReturnResult<UserAuthenOutput> authenCheck(@PathVariable("gameid") String gameid,
                                               @PathVariable("userno") String userno,
                                               @PathVariable("openid") String openid);

    // 根据userno查询用户身份证信息
    @GetMapping(path = "/api/fcm/queryuseridcard/{userno}")
    ReturnResult<UserIdCardOutput> queryUserIdCard(@PathVariable("userno") String userno);

    // 添加用户实名认证信息
    @PostMapping("/api/fcm/adduserauthen")
    Return addUserAuthen(@RequestParam Map<String, String> params);

    // 修改添加用户实名认证信息
    @PostMapping("/api/fcm/edituserauthen")
    Return editUserAuthen(@RequestParam Map<String, String> params);

    // 查询添加用户实名认证信息
    @GetMapping(path = "/api/fcm/queryuserauthen/{userno}")
    ReturnResult<UserAuthenOutput> queryUserAuthen(@PathVariable("userno") String userno);


}
