/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.niux.compatible.client;

import com.xunyi.beast.data.message.Return;
import com.xunyi.beast.data.message.ReturnResult;
import com.xunyi.niux.compatible.client.dto.CreateGameInput;
import com.xunyi.niux.compatible.client.dto.CreateGameOrderInput;
import com.xunyi.niux.compatible.client.dto.CreateGameOrderOutput;
import com.xunyi.niux.compatible.client.dto.EditGameInput;
import com.xunyi.niux.compatible.client.dto.EditGameMoneyInput;
import com.xunyi.niux.compatible.client.dto.GameInfo;
import com.xunyi.niux.compatible.client.dto.GameOrder;
import com.xunyi.niux.compatible.client.dto.GamePayCallBackInput;
import com.xunyi.niux.compatible.client.dto.GameServer;
import com.xunyi.niux.compatible.client.dto.GamesFcmOutput;
import com.xunyi.niux.compatible.client.dto.MoyuVip;
import com.xunyi.niux.compatible.client.dto.NiuXPlayer;
import com.xunyi.niux.compatible.client.dto.PlayerOpenId;
import com.xunyi.niux.compatible.client.dto.UserAuthenOutput;
import com.xunyi.niux.compatible.client.dto.UserIdCardOutput;
import com.xunyi.niux.compatible.client.dto.UserIdOutput;
import com.xunyi.niux.compatible.client.dto.UserinfoOutput;
import java.util.Map;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value="niux-compatible")
public interface NiuxCompatibleClient {
    @GetMapping(value={"/api/users/{userId}"})
    public ReturnResult<UserinfoOutput> user(@PathVariable(value="userId") String var1);

    @PostMapping(value={"/api/games/create"})
    public ReturnResult<GameInfo> createGame(@RequestBody CreateGameInput var1);

    @PostMapping(value={"/api/games/edit"})
    public ReturnResult<GameInfo> editGame(@RequestBody EditGameInput var1);

    @PostMapping(value={"/api/games/editgamemoney"})
    public ReturnResult<GameInfo> editGameMoney(@RequestBody EditGameMoneyInput var1);

    @GetMapping(value={"/api/games/{gameId}"})
    public ReturnResult<GameInfo> getGameInfoById(@PathVariable(value="gameId") String var1);

    @PostMapping(value={"/api/game/{gameId}/orders"})
    public ReturnResult<CreateGameOrderOutput> createGameOrder(@PathVariable(value="gameId") String var1, @RequestBody CreateGameOrderInput var2);

    @GetMapping(value={"/api/game-orders/{orderNo}"})
    public ReturnResult<GameOrder> getOrder(@PathVariable(value="orderNo") String var1);

    @PostMapping(value={"/api/game/pay/callback"})
    public ReturnResult<Return> gamePayCallBack(@RequestBody GamePayCallBackInput var1);

    @GetMapping(value={"/api/games/{gameId}/servers/{serverId}"})
    public ReturnResult<GameServer> getGameServerBy(@PathVariable(value="gameId") String var1, @PathVariable(value="serverId") Integer var2);

    @GetMapping(value={"/api/players/{userId}"})
    public ReturnResult<NiuXPlayer> getPlayer(@PathVariable(value="userId") String var1);

    @GetMapping(value={"/api/players/{userId}/games/{gameId}/account"})
    public ReturnResult<PlayerOpenId> getPlayerOpenId(@PathVariable(value="userId") String var1, @PathVariable(value="gameId") String var2);

    @GetMapping(value={"/api/players/customer/{customerId}/games/{gameId}/account"})
    public ReturnResult<UserIdOutput> getUserId(@PathVariable(value="customerId") String var1, @PathVariable(value="gameId") String var2);

    @GetMapping(value={"/api/games/000001/players/{userId}/vip"})
    public ReturnResult<MoyuVip> getMoyuPlayerVip(@PathVariable(value="userId") String var1);

    @PostMapping(value={"/api/fcm/addbizid"})
    public Return addGameBizId(@RequestParam Map<String, String> var1);

    @PostMapping(value={"/api/fcm/editbizid"})
    public Return editGameBizId(@RequestParam Map<String, String> var1);

    @GetMapping(path={"/api/fcm/querybizid/{gameId}"})
    public ReturnResult<GamesFcmOutput> queryGameBizId(@PathVariable(value="gameId") String var1);

    @GetMapping(value={"/api/fcm/authencheck/{gameid}/{userno}/{openid}"})
    public ReturnResult<UserAuthenOutput> authenCheck(@PathVariable(value="gameid") String var1, @PathVariable(value="userno") String var2, @PathVariable(value="openid") String var3);

    @GetMapping(path={"/api/fcm/queryuseridcard/{userno}"})
    public ReturnResult<UserIdCardOutput> queryUserIdCard(@PathVariable(value="userno") String var1);

    @PostMapping(value={"/api/fcm/adduserauthen"})
    public Return addUserAuthen(@RequestParam Map<String, String> var1);

    @PostMapping(value={"/api/fcm/edituserauthen"})
    public Return editUserAuthen(@RequestParam Map<String, String> var1);

    @GetMapping(path={"/api/fcm/queryuserauthen/{userno}"})
    public ReturnResult<UserAuthenOutput> queryUserAuthen(@PathVariable(value="userno") String var1);
}

