package com.xunyi.niux.compatible.client.dto;

import com.xunyi.beast.data.money.SimpleMoney;
import lombok.Getter;
import lombok.Setter;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

@Getter
@Setter
public class GameOrder {

    //订单号
    private String orderNo;

    //用户ID
    private long uid;


    //区服ID：可能为空
    @Nullable
    private Long serverId;

    //渠道区服ID
    @Nullable
    private String channelServerId;

    //渠道角色ID
    @Nullable
    private String channelRoleId;

    //角色名称
    @Nullable
    private String roleName;

    //游戏方:附带订单号可选参数
    @Nullable
    private String outOrderNo;

    //订单原始金额
    @NonNull
    private SimpleMoney originalMoney;

    //订单所需金额
    private SimpleMoney totalMoney;

    //客户端IP
    private String clientIp;

    //支付方式: WECHATPAY, ALIPAY等
    private String payMethod;

    //支付模式JSAPI等
    private String payMode;

    //支付金额
    private SimpleMoney paymentMoney;

    //订单支付状态
    private GameOrderPaymentStatus paymentStatus;

    //voucher 暂忽略


}
