package com.xunyi.niux.compatible.client;


import com.xunyi.beast.data.message.Return;
import com.xunyi.beast.data.message.ReturnResult;
import com.xunyi.niux.compatible.client.dto.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

@FeignClient("niux-compatible")
public interface NiuxCompatibleClient {

    // 创建游戏
    @PostMapping("/api/games/create")
    ReturnResult<GameInfo> createGame(@RequestBody CreateGameInput input);

    // 修改游戏
    @PostMapping("/api/games/edit")
    ReturnResult<GameInfo> editGame(@RequestBody EditGameInput input);

    // 修改游戏币
    @PostMapping("/api/games/editgamemoney")
    ReturnResult<GameInfo> editGameMoney(@RequestBody EditGameMoneyInput input);

    // 根据游戏ID查询游戏信息
    @GetMapping("/api/games/{gameId}")
    ReturnResult<GameInfo> getGameInfoById(
            @PathVariable("gameId") String gameId
    );

    //创建游戏-订单
    @PostMapping("/api/game/{gameId}/orders")
    ReturnResult<CreateGameOrderOutput> createGameOrder(
            @PathVariable("gameId") String gameId,
            @RequestBody CreateGameOrderInput input);

    // 查询没有外呼记录的充值用户信息
    @GetMapping("/api/game/pay/nocallrecord")
    ReturnResult<List<NoCallRechargeOutput>> getNoCallRechargeInfo(@RequestBody NoCallRechargeInput input);

    //查询游戏订单
    @GetMapping("/api/game-orders/{orderNo}")
    ReturnResult<GameOrder> getOrder(
            @PathVariable("orderNo") String orderNo
    );

    // 支付回调
    @PostMapping("/api/game/pay/callback")
    ReturnResult<Return> gamePayCallBack(@RequestBody GamePayCallBackInput input);

    // 查询游戏区服信息
    @GetMapping("/api/games/{gameId}/servers/{serverId}")
    ReturnResult<GameServer> getGameServerBy(@PathVariable("gameId") String gameId,
                                             @PathVariable("serverId") Integer serverId);

    @GetMapping("/api/players/{userId}")
    ReturnResult<NiuXPlayer> getPlayer(@PathVariable("userId") String userId);

    // 查询玩家账号
    @GetMapping("/api/players/{userId}/games/{gameId}/account")
    ReturnResult<PlayerOpenId> getPlayerOpenId(@PathVariable("userId") String userId,
                                               @PathVariable("gameId") String gameId);

    // 查询魔域玩家 vip信息
    @GetMapping("/api/games/000001/players/{userId}/vip")
    ReturnResult<MoyuVip> getMoyuPlayerVip(@PathVariable("userId") String userId);


}
