/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.niux.compatible.client;

import com.xunyi.beast.data.message.Return;
import com.xunyi.beast.data.message.ReturnResult;
import com.xunyi.niux.compatible.client.dto.CreateGameInput;
import com.xunyi.niux.compatible.client.dto.CreateGameOrderInput;
import com.xunyi.niux.compatible.client.dto.CreateGameOrderOutput;
import com.xunyi.niux.compatible.client.dto.EditGameInput;
import com.xunyi.niux.compatible.client.dto.EditGameMoneyInput;
import com.xunyi.niux.compatible.client.dto.GameInfo;
import com.xunyi.niux.compatible.client.dto.GameOrder;
import com.xunyi.niux.compatible.client.dto.GamePayCallBackInput;
import com.xunyi.niux.compatible.client.dto.GameServer;
import com.xunyi.niux.compatible.client.dto.MoyuVip;
import com.xunyi.niux.compatible.client.dto.PlayerOpenId;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@FeignClient(value="niux-compatible")
public interface NiuxCompatibleClient {
    @PostMapping(value={"/api/games/create"})
    public ReturnResult<GameInfo> createGame(@RequestBody CreateGameInput var1);

    @PostMapping(value={"/api/games/edit"})
    public ReturnResult<GameInfo> editGame(@RequestBody EditGameInput var1);

    @PostMapping(value={"/api/games/editgamemoney"})
    public ReturnResult<GameInfo> editGameMoney(@RequestBody EditGameMoneyInput var1);

    @GetMapping(value={"/api/games/{gameId}"})
    public ReturnResult<GameInfo> getGameInfoById(@PathVariable(value="gameId") String var1);

    @PostMapping(value={"/api/game/{gameId}/orders"})
    public ReturnResult<CreateGameOrderOutput> createGameOrder(@PathVariable(value="gameId") String var1, @RequestBody CreateGameOrderInput var2);

    @GetMapping(value={"/api/game-orders/{orderNo}"})
    public ReturnResult<GameOrder> getOrder(@PathVariable(value="orderNo") String var1);

    @PostMapping(value={"/api/game/pay/callback"})
    public ReturnResult<Return> gamePayCallBack(@RequestBody GamePayCallBackInput var1);

    @GetMapping(value={"/api/games/{gameId}/servers/{serverId}"})
    public ReturnResult<GameServer> getGameServerBy(@PathVariable(value="gameId") String var1, @PathVariable(value="serverId") Integer var2);

    @GetMapping(value={"/api/players/{userId}/games/{gameId}/account"})
    public ReturnResult<PlayerOpenId> getPlayerOpenId(@PathVariable(value="userId") String var1, @PathVariable(value="gameId") String var2);

    @GetMapping(value={"/api/games/000001/players/{userId}/vip"})
    public ReturnResult<MoyuVip> getMoyuPlayerVip(@PathVariable(value="userId") String var1);
}

